# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1
        return "C"
    
    # Check for hardcoded strategies in opponent's code
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    always_cooperate = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    
    if always_cooperate:
        return "D"
    if always_defect:
        return "D"
    
    current_round = len(my_history) + 1
    
    if current_round >= 9:  # Rounds 9-10: defect
        return "D"
    
    # Rounds 2-8: Tit-for-Tat with Forgiveness
    if opp_history[-1] == "C":
        return "C"
    else:
        # 10% chance to forgive
        if random.random() < 0.1:
            return "C"
        else:
            return "D"